%     NITOOL     NATURE INSPIRED TOOLBOX

% ======================================================
%   PROGRAM AIM :
%         TO EVOLVE SYSTEMS USING NATURE INSPIRED TOOLBOX [NIT]
% ======================================================
%   USAGE :
%         1. validate(Pop, Chk)
%         2. nitool(GFSStructure)
%         3. nitool
% ==============================================
%   SATVIR SINGH SIDHU, ARUN KHOSLA, JASBIR SINGH SAINI
%   JULY 2009
%   COPYRIGHT RESERVED
% ==============================================

function newpop = validate(P, Chk)
newpop = [];

PS = size(P);
PC = size(Chk);

for r = 1:size(P, 1)
    for n = 1:size(Chk, 1)
        switch Chk(n, 2)
            case 1  % <
                R(r, n) = P(r, Chk(n, 1)) < P(r, Chk(n, 3));
            case 2  % >
                R(r, n) = P(r, Chk(n, 1)) > P(r, Chk(n, 3));
            case 3  % <=
                R(r, n) = P(r, Chk(n, 1)) < P(r, Chk(n, 3));
            case 4  % >=
                R(r, n) = P(r, Chk(n, 1)) > P(r, Chk(n, 3));
            case 5 % ==
                'Pending'
            case 6 % ~=
                'Pending'
            otherwise
                error('Wrong Relational Operator');
        end
        % Swap Values if Required Relation is False
        if R(r, n) == 0
            tmp = P(r, Chk(n, 1));
            P(r, Chk(n, 1)) = P(r, Chk(n, 3));
            P(r, Chk(n, 3)) = tmp;
            R(r, n) = 1;
            n = n-1; 
        end
    end
end
newpop = P;